unit Nyomo1u;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Sugar: TEdit;
    Terulet: TButton;
    Kerulet: TButton;
    Kilepes: TButton;
    Label2: TLabel;
    Eredmeny: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    procedure TeruletClick(Sender: TObject);
    procedure SugarChange(Sender: TObject);
    procedure KeruletClick(Sender: TObject);
    procedure KilepesClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    R : real;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

function Str2Dbl(const s: string):double;
var  dc : char;
begin
  dc := decimalseparator;
  if pos(',',s) <> 0 then
    decimalseparator := ','
  else
    decimalseparator := '.';
  try
     Str2Dbl := strToFloat(s);
  except
     Str2Dbl := 0;
  end;
  decimalseparator := dc;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
   Kerulet.Default := true; // Return billentyre is mkdik
   Kilepes.Cancel  := true; // az Esc billentyre is mkdik
   Eredmeny.ReadOnly := true; // a szvegmez csak olvashat
   Eredmeny.Text := '';
end;

procedure TForm1.SugarChange(Sender: TObject);
begin
  Label2.Caption := '';
  Eredmeny.Clear;
end;

procedure TForm1.TeruletClick(Sender: TObject);
begin
  if  length(Sugar.Text) > 0 then
  begin
    R := Str2Dbl(Sugar.Text);
    if R > 0 then
    begin
      Label2.Caption := 'A kr terlete';
      Eredmeny.Text := FloatToStr(sqr(R)*pi);
    end;
    Kerulet.SetFocus;
  end;
end;

procedure TForm1.KeruletClick(Sender: TObject);
begin
  if  length(Sugar.Text) > 0 then
  begin
    R := Str2Dbl(Sugar.Text);
    if R > 0 then
    begin
      Label2.Caption := 'A kr kerlete';
      Eredmeny.Text := FloatToStr(2*R*pi);
    end;
  end;
end;

procedure TForm1.KilepesClick(Sender: TObject);
begin
   Application.Terminate;
end;

end.
